/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.client.gui;

import com.google.common.collect.ImmutableSortedSet;
import compasses.expandedstorage.impl.CommonClient;
import compasses.expandedstorage.impl.client.gui.AbstractScreen;
import compasses.expandedstorage.impl.client.gui.widget.PickButton;
import compasses.expandedstorage.impl.client.gui.widget.ScreenPickButton;
import compasses.expandedstorage.impl.inventory.handler.AbstractHandler;
import compasses.expandedstorage.impl.misc.Utils;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class PickScreen
extends Screen {
    public static final Component CURRENT_OPTION_TEXT = Component.m_237115_((String)"screen.expandedstorage.current_option_notice").m_130940_(ChatFormatting.GOLD);
    public static final Map<ResourceLocation, PickButton> BUTTON_SETTINGS = Map.of(Utils.PAGINATED_SCREEN_TYPE, new PickButton(Utils.id("textures/gui/page_button.png"), (Component)Component.m_237115_((String)"screen.expandedstorage.page_screen"), new Component[0]), Utils.SCROLLABLE_SCREEN_TYPE, new PickButton(Utils.id("textures/gui/scroll_button.png"), (Component)Component.m_237115_((String)"screen.expandedstorage.scroll_screen"), new Component[0]), Utils.SINGLE_SCREEN_TYPE, new PickButton(Utils.id("textures/gui/single_button.png"), (Component)Component.m_237115_((String)"screen.expandedstorage.single_screen"), new Component[]{Component.m_237115_((String)"screen.expandedstorage.off_screen_warning_1").m_130940_(ChatFormatting.GRAY), Component.m_237115_((String)"screen.expandedstorage.off_screen_warning_2").m_130940_(ChatFormatting.GRAY)}){

        @Override
        public boolean shouldShowWarning(int scaledWidth, int scaledHeight) {
            return scaledWidth < 370 || scaledHeight < 386;
        }
    });
    private final Set<ResourceLocation> options = ImmutableSortedSet.copyOf(BUTTON_SETTINGS.keySet());
    private final Supplier<Screen> returnToScreen;
    private final AbstractHandler handler;
    private int topPadding;

    public PickScreen(AbstractScreen currentScreen) {
        this((AbstractHandler)currentScreen.m_6262_(), () -> AbstractScreen.createScreen((AbstractHandler)currentScreen.m_6262_(), Minecraft.m_91087_().f_91074_.m_150109_(), currentScreen.m_96636_()));
    }

    public PickScreen(Screen returnToScreen) {
        this(null, () -> returnToScreen);
    }

    private PickScreen(@Nullable AbstractHandler handler, Supplier<Screen> returnToScreen) {
        super((Component)Component.m_237115_((String)"screen.expandedstorage.screen_picker_title"));
        this.handler = handler;
        this.returnToScreen = returnToScreen;
    }

    public void m_7379_() {
        if (this.handler != null) {
            ResourceLocation preference = CommonClient.platformHelper().configWrapper().getPreferredScreenType();
            if (preference == null) {
                this.f_96541_.f_91074_.m_6915_();
                return;
            }
            if (AbstractScreen.getScreenSize(preference, this.handler.getInventory().m_6643_(), this.f_96541_.m_91268_().m_85445_(), this.f_96541_.m_91268_().m_85446_()) == null) {
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237115_((String)"text.expandedstorage.short_prefix").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237110_((String)"chat.expandedstorage.cannot_display_screen", (Object[])new Object[]{Component.m_237115_((String)("screen." + preference.m_135827_() + "." + preference.m_135815_() + "_screen"))}).m_130940_(ChatFormatting.WHITE)), false);
                this.f_96541_.f_91074_.m_6915_();
                return;
            }
            this.handler.clearSlots();
        }
        this.f_96541_.m_91152_(this.returnToScreen.get());
    }

    public boolean m_7043_() {
        return this.f_96541_.f_91073_ == null;
    }

    protected void m_7856_() {
        int topPadding;
        super.m_7856_();
        ResourceLocation preference = CommonClient.platformHelper().configWrapper().getPreferredScreenType();
        int choices = this.options.size();
        int columns = Math.min(Math.floorDiv(this.f_96543_, 96), choices);
        int innerPadding = Math.min((this.f_96543_ - columns * 96) / (columns + 1), 20);
        int outerPadding = (this.f_96543_ - ((columns - 1) * innerPadding + columns * 96)) / 2;
        int x = 0;
        this.topPadding = topPadding = (this.f_96544_ - 96) / 2;
        for (ResourceLocation option : this.options) {
            PickButton settings = BUTTON_SETTINGS.get(option);
            boolean isWarn = settings.shouldShowWarning(this.f_96543_, this.f_96544_);
            boolean isCurrent = option.equals((Object)preference);
            MutableComponent tooltipMessage = Component.m_237113_((String)"").m_7220_(settings.getTitle());
            if (isCurrent) {
                tooltipMessage.m_130946_("\n");
                tooltipMessage.m_7220_(CURRENT_OPTION_TEXT);
            }
            if (isWarn) {
                tooltipMessage.m_130946_("\n");
                settings.getWarningText().forEach(arg_0 -> ((MutableComponent)tooltipMessage).m_7220_(arg_0));
            }
            this.m_142416_((GuiEventListener)new ScreenPickButton(outerPadding + (innerPadding + 96) * x, topPadding, 96, 96, settings.getTexture(), settings.getTitle(), isWarn, isCurrent, __ -> this.updatePlayerPreference(option), Tooltip.m_257563_((Component)tooltipMessage, (Component)tooltipMessage)));
            ++x;
        }
    }

    private void updatePlayerPreference(ResourceLocation selection) {
        CommonClient.platformHelper().configWrapper().setPreferredScreenType(selection);
        this.m_7379_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, Math.max(this.topPadding / 2, 0), -1);
    }
}

